/*global define */
/*jslint white: true */

/*
	AudioContainerStorage:

	This object provides a mixin for each item that can create a view container.
*/

define  ([  "src/utils", "src/build/AudioContainer", "src/build/containerStorage", "src/build/TimeItem"],
function(   utils, AudioContainer, containerStorage, TimeItem) {
	'use strict';

	function AudioContainerStorage(inCreatesContainers0, inAudibleByDefault0, inContainerName0) {
		utils.assert(this !== undefined, "AudioContainerStorage not called with new.");
		// do not modify these private members directly or notifiers won't be called correctly
		this.pAudioContainerStorage = {
			createsContainersB	: (inCreatesContainers0 === undefined) ? false : inCreatesContainers0,
			containerName0		: inContainerName0,
			enableByDefaultB	: (inAudibleByDefault0 === undefined) ? true : inAudibleByDefault0,
			container0			: null
		};
	}

	var containerStorageMixin = containerStorage({
		getDataStore : function (obj) {
			return obj.pAudioContainerStorage;
		},
		createContainer : function (inName0) {
			var audioContainer = new AudioContainer(inName0);
			TimeItem.prototype.clone.call(this, false, audioContainer);
			return audioContainer;
		},
		setEnabled : function (inEnableB, ioContainer) {
			ioContainer.setAudibleEnabled(inEnableB);
		},
		rename		: {	getContainer : "getAudioContainer",
						setContainer : "setAudioContainer",
						getParentContainer : "getParentAudioContainer",
						attachToRootContainer : "attachToRootAudioContainer"}
	});

	utils.mixin(AudioContainerStorage, containerStorageMixin);
	
	return AudioContainerStorage;
});
